function extraerDatosRIF_Limpio() {

    let datosRIF = {
        rif: 'NO ENCONTRADO',
        nombre: 'NO ENCONTRADO',
        actividad_economica: 'NO ENCONTRADO',
        condicion_iva: 'NO ENCONTRADO',
        retencion_iva: '0%' 
    };

    // 1. EXTRAER RIF y Nombre/Razón Social
    const elementoRIFNombre = document.querySelector('table[align="center"] font[face="Verdana"][size="2"]');
    if (elementoRIFNombre) {
        const textoCompleto = elementoRIFNombre.textContent.trim();
        const match = textoCompleto.match(/^(\w+)\s+(.+)$/);
        
        if (match && match.length === 3) {
            datosRIF.rif = match[1];
            datosRIF.nombre = match[2];
        }
    }

    // 2. EXTRAER INFORMACIÓN ADICIONAL DEL BLOQUE DE DETALLE
    // Selector CLAVE: Apunta a la TERCERA tabla (índice [2]) que contiene los detalles.
    const elementoDetalle = document.querySelectorAll('table')[2]?.querySelector('font[face="Verdana"][size="1"]');

    if (elementoDetalle) {
        // OBTENCIÓN Y LIMPIEZA: innerHTML para manejar <br> y luego normalizar.
        let textoLimpio = elementoDetalle.innerHTML
            .replace(/<br>/gi, ' ')     
            .replace(/&nbsp;/gi, ' ')
            .replace(/\s\s+/g, ' ')
            .trim();
        
        // a) Actividad Económica
        const matchActividad = textoLimpio.match(/Actividad Económica:\s*(.*?)\s*Condición:/i);
        if (matchActividad && matchActividad[1] && matchActividad[1].trim() !== 'INFORMACION NO DISPONIBLE') {
            datosRIF.actividad_economica = matchActividad[1].trim();
        }

        // b) Condición IVA
        const matchCondicion = textoLimpio.match(/Condición:\s*(.*?)(?:La condición de este contribuyente)/i);
        if (matchCondicion && matchCondicion[1]) {
            datosRIF.condicion_iva = matchCondicion[1].trim();
        }
        
        // c) Retención IVA
        const matchRetencion = textoLimpio.match(/retención del (\d+%) /i);
        
        if (matchRetencion && matchRetencion[1]) {
            datosRIF.retencion_iva = matchRetencion[1]; 
        }
    }

    // Muestra solo el resultado final
    console.table(datosRIF);

    return datosRIF;
}

// Ejecutar la función de extracción
extraerDatosRIF_Limpio();