// --- CONFIGURACIÓN ---
// Ingresa el RIF completo (Ej: V123456789).
const RIF_A_BUSCAR = 'J299036544';

// Ingresa manualmente el valor que ves en la imagen CAPTCHA.
const CODIGO_CAPTCHA = 'ckfen2'; // ¡DEBES CAMBIAR ESTE VALOR CADA VEZ!
// --------------------


// 1. Obtener referencias a los campos y al formulario.
const inputRif = document.getElementById('p_rif');
const inputCodigo = document.getElementById('codigo');
const botonBuscar = document.querySelector('input[type="submit"][value=" Buscar "]');
const formulario = document.getElementById('consulta');


// 2. Verificar que los elementos existan.
if (!inputRif || !inputCodigo || !botonBuscar || !formulario) {
    console.error('Error: No se pudieron encontrar todos los elementos del formulario (RIF, Código o Botón).');
} else {
    // 3. Llenar los campos con los valores definidos.

    // Para el RIF: Aseguramos que se envía en mayúsculas como lo requiere la página.
    inputRif.value = RIF_A_BUSCAR.toUpperCase();
    
    // Para el Código CAPTCHA:
    inputCodigo.value = CODIGO_CAPTCHA;

    console.log(`Campos llenados: RIF=${inputRif.value}, CAPTCHA=${inputCodigo.value}`);
    
    // 4. Simular el envío del formulario.
    // Esto es equivalente a hacer clic en el botón "Buscar".
    formulario.submit(); 

    // Opcionalmente, si la función doSubmit() es importante para el envío, 
    // podrías intentar simular el clic directo:
    // botonBuscar.click(); 

    console.log('Formulario enviado. Esperando la respuesta del SENIAT...');
}